/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IPAddressJTextField
extends JTextField {
    public static final String INIT_STRING = "   .   .   .   ";
    public static final char SEPARATOR = '.';
    public int SEGMENT_LEGTH = "   .   .   .   ".indexOf(46);
    public static final int MAX_SEGMENT_VALUE = 255;
    private int fMaxFirstSegmentValue = 223;

    public IPAddressJTextField() {
        super(INIT_STRING.length() + 1);
        this.setDocument(new IPMASKDocument());
        this.setText(INIT_STRING);
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                int dot = e.getDot();
                if (dot != IPAddressJTextField.this.getDocument().getLength() && IPAddressJTextField.INIT_STRING.charAt(dot) != '.') {
                    int dotIndex = IPAddressJTextField.INIT_STRING.indexOf(46, dot);
                    IPAddressJTextField.this.setCaretPosition(dotIndex == -1 ? IPAddressJTextField.this.getDocument().getLength() : dotIndex);
                }
            }
        });
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout());
        IPAddressJTextField ip = new IPAddressJTextField();
        ip.setMaxFirstSegmentValue(223);
        ip.setIP("192.036.1.176");
        panel.add((Component)ip, 0);
        frame.add(panel);
        frame.setSize(800, 300);
        frame.setVisible(true);
    }

    public void resetIP() {
        this.setText(INIT_STRING);
        this.setCaretPosition(0);
    }

    public String getIP() {
        if (this.getText().equals(INIT_STRING)) {
            return "";
        }
        return this.getText().replace(" ", "");
    }

    public void setIP(String ip) {
        if (ip == null || ip.equals("")) {
            this.resetIP();
        } else {
            this.setText(ip);
        }
    }

    public int getMaxFirstSegmentValue() {
        return this.fMaxFirstSegmentValue;
    }

    public void setMaxFirstSegmentValue(int fMaxFirstSegmentValue) {
        this.fMaxFirstSegmentValue = fMaxFirstSegmentValue;
    }

    public static boolean isIPAddressLegal(String ip) {
        String ipAddress = "((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])";
        Pattern pattern = Pattern.compile(ipAddress);
        Matcher matcher = pattern.matcher(ip);
        return matcher.matches();
    }

    class IPMASKDocument
    extends PlainDocument {
        IPMASKDocument() {
        }

        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            if (str.equals(IPAddressJTextField.INIT_STRING)) {
                if (this.getLength() == 0) {
                    super.insertString(offset, str, a);
                } else {
                    this.replaceString(offset, str, a);
                }
                return;
            }
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == ' ') continue;
                if (offset > IPAddressJTextField.INIT_STRING.length() || !Character.isDigit(c) && c != '.') {
                    return;
                }
                if (c == '.') {
                    if (offset >= IPAddressJTextField.INIT_STRING.length()) {
                        return;
                    }
                    int start = offset - offset % 4;
                    String segmentText = this.getText(start, IPAddressJTextField.this.SEGMENT_LEGTH).replace(" ", "").trim();
                    if (segmentText == null || segmentText.equals("")) {
                        return;
                    }
                    IPAddressJTextField.this.setCaretPosition(offset += 4);
                    continue;
                }
                this.insertChar(offset, c, a);
            }
        }

        public void remove(int offset, int len) throws BadLocationException {
            if (len == 0) {
                return;
            }
            if (len == IPAddressJTextField.INIT_STRING.length()) {
                super.remove(0, len);
                super.insertString(0, IPAddressJTextField.INIT_STRING, this.getAttributeContext().getEmptySet());
                offset = IPAddressJTextField.INIT_STRING.indexOf(46);
                IPAddressJTextField.this.setCaretPosition(offset);
                return;
            }
            int start = offset - offset % 4;
            if (this.getText(start, IPAddressJTextField.this.SEGMENT_LEGTH).trim().length() == 0 && offset > IPAddressJTextField.this.SEGMENT_LEGTH) {
                IPAddressJTextField.this.setCaretPosition(offset -= IPAddressJTextField.this.SEGMENT_LEGTH);
                return;
            }
            this.replaceString(offset, IPAddressJTextField.INIT_STRING.substring(offset, offset + len), this.getAttributeContext().getEmptySet());
            String segmentText = Util.addLeadingSpaces(this.getText(start, IPAddressJTextField.this.SEGMENT_LEGTH).replace(" ", ""), IPAddressJTextField.this.SEGMENT_LEGTH);
            this.replaceString(start, segmentText, this.getAttributeContext().getEmptySet());
            IPAddressJTextField.this.setCaretPosition(offset);
        }

        protected void insertChar(int offset, char c, AttributeSet a) throws BadLocationException {
            int start = offset - offset % 4;
            String segmentText = this.getText(start, IPAddressJTextField.this.SEGMENT_LEGTH).replace(" ", "").trim();
            if (segmentText.length() == IPAddressJTextField.this.SEGMENT_LEGTH) {
                if (offset <= IPAddressJTextField.INIT_STRING.lastIndexOf(46)) {
                    IPAddressJTextField.this.setCaretPosition(offset + 4);
                }
                return;
            }
            segmentText = segmentText + c;
            int maxValue = 255;
            int minFirstQuad = 0;
            if (start == 0) {
                minFirstQuad = 1;
                maxValue = IPAddressJTextField.this.getMaxFirstSegmentValue();
            }
            if (Integer.valueOf(segmentText) > maxValue || start == 0 && Integer.valueOf(segmentText) == 0) {
                Object[] info = new Object[]{segmentText, minFirstQuad, maxValue};
                new LogoError(null, "panel.ip.msg.ipOutOfRange", segmentText + " is not a valid entry. Please specify a value between " + minFirstQuad + " and " + maxValue, info, 2, 0).display();
                segmentText = String.valueOf(maxValue);
            }
            if ((segmentText = Integer.valueOf(segmentText).toString()).length() == IPAddressJTextField.this.SEGMENT_LEGTH) {
                offset = offset <= IPAddressJTextField.INIT_STRING.lastIndexOf(46) ? offset + IPAddressJTextField.this.SEGMENT_LEGTH + 1 : IPAddressJTextField.INIT_STRING.length();
            } else {
                segmentText = "   ".substring(0, IPAddressJTextField.this.SEGMENT_LEGTH - segmentText.length()) + segmentText;
            }
            this.replaceString(start, segmentText, a);
            IPAddressJTextField.this.setCaretPosition(offset);
        }

        private void replaceString(int offset, String st, AttributeSet a) throws BadLocationException {
            super.remove(offset, st.length());
            super.insertString(offset, st, a);
        }
    }
}

